#![allow(unknown_lints)]
#![allow(clippy::all)]
#![allow(
    missing_debug_implementations,
    missing_copy_implementations,
    trivial_casts,
    trivial_numeric_casts,
    unsafe_code,
    unstable_features,
    unused_import_braces,
    unused_qualifications,
    unused_imports
)]
// This code was autogenerated with `dbus-codegen-rust -m None -c ffidisp`, see https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::ffidisp;

pub trait OrgMprisMediaPlayer2TrackList {
    fn get_tracks_metadata(
        &self,
        track_ids: Vec<dbus::Path>,
    ) -> Result<Vec<arg::PropMap>, dbus::Error>;
    fn add_track(
        &self,
        uri: &str,
        after_track: dbus::Path,
        set_as_current: bool,
    ) -> Result<(), dbus::Error>;
    fn remove_track(&self, track_id: dbus::Path) -> Result<(), dbus::Error>;
    fn go_to(&self, track_id: dbus::Path) -> Result<(), dbus::Error>;
    fn tracks(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn can_edit_tracks(&self) -> Result<bool, dbus::Error>;
}

#[derive(Debug)]
pub struct OrgMprisMediaPlayer2TrackListTrackListReplaced {
    pub tracks: Vec<dbus::Path<'static>>,
    pub current_track: dbus::Path<'static>,
}

impl arg::AppendAll for OrgMprisMediaPlayer2TrackListTrackListReplaced {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.tracks, i);
        arg::RefArg::append(&self.current_track, i);
    }
}

impl arg::ReadAll for OrgMprisMediaPlayer2TrackListTrackListReplaced {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgMprisMediaPlayer2TrackListTrackListReplaced {
            tracks: i.read()?,
            current_track: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgMprisMediaPlayer2TrackListTrackListReplaced {
    const NAME: &'static str = "TrackListReplaced";
    const INTERFACE: &'static str = "org.mpris.MediaPlayer2.TrackList";
}

#[derive(Debug)]
pub struct OrgMprisMediaPlayer2TrackListTrackAdded {
    pub metadata: arg::PropMap,
    pub after_track: dbus::Path<'static>,
}

impl arg::AppendAll for OrgMprisMediaPlayer2TrackListTrackAdded {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.metadata, i);
        arg::RefArg::append(&self.after_track, i);
    }
}

impl arg::ReadAll for OrgMprisMediaPlayer2TrackListTrackAdded {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgMprisMediaPlayer2TrackListTrackAdded {
            metadata: i.read()?,
            after_track: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgMprisMediaPlayer2TrackListTrackAdded {
    const NAME: &'static str = "TrackAdded";
    const INTERFACE: &'static str = "org.mpris.MediaPlayer2.TrackList";
}

#[derive(Debug)]
pub struct OrgMprisMediaPlayer2TrackListTrackRemoved {
    pub track_id: dbus::Path<'static>,
}

impl arg::AppendAll for OrgMprisMediaPlayer2TrackListTrackRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.track_id, i);
    }
}

impl arg::ReadAll for OrgMprisMediaPlayer2TrackListTrackRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgMprisMediaPlayer2TrackListTrackRemoved {
            track_id: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgMprisMediaPlayer2TrackListTrackRemoved {
    const NAME: &'static str = "TrackRemoved";
    const INTERFACE: &'static str = "org.mpris.MediaPlayer2.TrackList";
}

#[derive(Debug)]
pub struct OrgMprisMediaPlayer2TrackListTrackMetadataChanged {
    pub track_id: dbus::Path<'static>,
    pub metadata: arg::PropMap,
}

impl arg::AppendAll for OrgMprisMediaPlayer2TrackListTrackMetadataChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.track_id, i);
        arg::RefArg::append(&self.metadata, i);
    }
}

impl arg::ReadAll for OrgMprisMediaPlayer2TrackListTrackMetadataChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgMprisMediaPlayer2TrackListTrackMetadataChanged {
            track_id: i.read()?,
            metadata: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgMprisMediaPlayer2TrackListTrackMetadataChanged {
    const NAME: &'static str = "TrackMetadataChanged";
    const INTERFACE: &'static str = "org.mpris.MediaPlayer2.TrackList";
}

impl<'a, C: ::std::ops::Deref<Target = ffidisp::Connection>> OrgMprisMediaPlayer2TrackList
    for ffidisp::ConnPath<'a, C>
{
    fn get_tracks_metadata(
        &self,
        track_ids: Vec<dbus::Path>,
    ) -> Result<Vec<arg::PropMap>, dbus::Error> {
        self.method_call(
            "org.mpris.MediaPlayer2.TrackList",
            "GetTracksMetadata",
            (track_ids,),
        )
        .and_then(|r: (Vec<arg::PropMap>,)| Ok(r.0))
    }

    fn add_track(
        &self,
        uri: &str,
        after_track: dbus::Path,
        set_as_current: bool,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.mpris.MediaPlayer2.TrackList",
            "AddTrack",
            (uri, after_track, set_as_current),
        )
    }

    fn remove_track(&self, track_id: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call(
            "org.mpris.MediaPlayer2.TrackList",
            "RemoveTrack",
            (track_id,),
        )
    }

    fn go_to(&self, track_id: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.mpris.MediaPlayer2.TrackList", "GoTo", (track_id,))
    }

    fn tracks(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2.TrackList",
            "Tracks",
        )
    }

    fn can_edit_tracks(&self) -> Result<bool, dbus::Error> {
        <Self as ffidisp::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.mpris.MediaPlayer2.TrackList",
            "CanEditTracks",
        )
    }
}
