/**
 * Furnace Tracker - multi-system chiptune tracker
 * Copyright (C) 2021-2025 tildearrow and contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _POKEY_H
#define _POKEY_H

#include "../dispatch.h"
#include "../../fixedQueue.h"

extern "C" {
#include "sound/pokey/mzpokeysnd.h"
}

#include "sound/pokey/AltASAP.hpp"


class DivPlatformPOKEY: public DivDispatch {
  struct Channel: public SharedChannel<int> {
    unsigned char wave;
    bool ctlChanged;
    Channel():
      SharedChannel<int>(15),
      wave(5),
      ctlChanged(true) {}
  };
  Channel chan[4];
  DivDispatchOscBuffer* oscBuf[4];
  bool isMuted[4];
  struct QueuedWrite {
    unsigned char addr;
    unsigned char val;
    QueuedWrite(): addr(0), val(0) {}
    QueuedWrite(unsigned char a, unsigned char v): addr(a), val(v) {}
  };
  FixedQueue<QueuedWrite,128> writes;
  unsigned char audctl, skctl;
  bool audctlChanged, skctlChanged;
  unsigned char oscBufDelay;
  PokeyState pokey;
  AltASAP::Pokey altASAP;
  bool useAltASAP;
  unsigned char regPool[16];
  friend void putDispatchChip(void*,int);
  friend void putDispatchChan(void*,int,int);
  public:
    void acquire(short** buf, size_t len);
    void acquireMZ(short* buf, size_t len);
    void acquireASAP(short* buf, size_t len);
    int dispatch(DivCommand c);
    void* getChanState(int chan);
    DivMacroInt* getChanMacroInt(int ch);
    void getPaired(int ch, std::vector<DivChannelPair>& ret);
    DivDispatchOscBuffer* getOscBuffer(int chan);
    unsigned char* getRegisterPool();
    int getRegisterPoolSize();
    void reset();
    void forceIns();
    void tick(bool sysTick=true);
    void muteChannel(int ch, bool mute);
    bool keyOffAffectsArp(int ch);
    float getPostAmp();
    void setFlags(const DivConfig& flags);
    void notifyInsDeletion(void* ins);
    void poke(unsigned int addr, unsigned short val);
    void poke(std::vector<DivRegWrite>& wlist);
    const char** getRegisterSheet();
    int init(DivEngine* parent, int channels, int sugRate, const DivConfig& flags);
    void quit();
    void setAltASAP(bool useAltASAP);
    ~DivPlatformPOKEY();
};

#endif
