﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Threading;
using System.Threading.Tasks;
using BenchmarkDotNet.Attributes;

namespace IdeBenchmarks.StackTraceExplorer
{
    [MemoryDiagnoser]
    public class StackTraceExplorerBenchmarks
    {
        [Benchmark]
        public async Task BenchmarkStackTraceParsing()
        {
            var result = await Microsoft.CodeAnalysis.StackTraceExplorer.StackTraceAnalyzer.AnalyzeAsync(Stack, CancellationToken.None);
            Console.WriteLine($"Total {result.ParsedFrames.Length} items");
        }

        private const string Stack = @"
Stack overflow.
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelpOrErrorIfAppropriate(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.CommandBase.ShowHelpOrErrorIfAppropriate(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Tools.Tool.Run.ToolRunCommand..ctor(System.CommandLine.Parsing.ParseResult, Microsoft.DotNet.CommandFactory.LocalToolsCommandResolver)
   at Microsoft.DotNet.Cli.ToolRunCommandParser+<>c.<ConstructCommand>b__3_0(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.ParseResultCommandHandler.InvokeAsync(System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_0+<<BuildInvocationChain>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_0+<<BuildInvocationChain>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<BuildInvocationChain>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_0+<<BuildInvocationChain>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<BuildInvocationChain>b__0>d ByRef)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_0.<BuildInvocationChain>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_2.<BuildInvocationChain>b__3(System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass13_0+<<UseHelp>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass13_0+<<UseHelp>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseHelp>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass13_0+<<UseHelp>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseHelp>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass13_0.<UseHelp>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_2.<BuildInvocationChain>b__3(System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c+<<UseSuggestDirective>b__19_0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c+<<UseSuggestDirective>b__19_0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseSuggestDirective>b__19_0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c+<<UseSuggestDirective>b__19_0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseSuggestDirective>b__19_0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c.<UseSuggestDirective>b__19_0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_2.<BuildInvocationChain>b__3(System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass17_0+<<UseParseDirective>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass17_0+<<UseParseDirective>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseParseDirective>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass17_0+<<UseParseDirective>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseParseDirective>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass17_0.<UseParseDirective>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_2.<BuildInvocationChain>b__3(System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.ParseResultExtensions.ShowHelp(System.CommandLine.Parsing.ParseResult)
   at Microsoft.DotNet.Cli.Parser.ExceptionHandler(System.Exception, System.CommandLine.Invocation.InvocationContext)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d.MoveNext()
   at System.Runtime.CompilerServices.AsyncMethodBuilderCore.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.Runtime.CompilerServices.AsyncTaskMethodBuilder.Start[[System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0+<<UseExceptionHandler>b__0>d, System.CommandLine, Version=2.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35]](<<UseExceptionHandler>b__0>d ByRef)
   at System.CommandLine.Builder.CommandLineBuilderExtensions+<>c__DisplayClass9_0.<UseExceptionHandler>b__0(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline+<>c__DisplayClass4_1.<BuildInvocationChain>b__2(System.CommandLine.Invocation.InvocationContext, System.Func`2<System.CommandLine.Invocation.InvocationContext,System.Threading.Tasks.Task>)
   at System.CommandLine.Invocation.InvocationPipeline.Invoke(System.CommandLine.IConsole)
   at System.CommandLine.Parsing.ParseResultExtensions.Invoke(System.CommandLine.Parsing.ParseResult, System.CommandLine.IConsole)
   at Microsoft.DotNet.Cli.Program.ProcessArgs(System.String[], System.TimeSpan, Microsoft.DotNet.Cli.Telemetry.ITelemetry)
   at Microsoft.DotNet.Cli.Program.Main(System.String[])";

    }
}
