% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_logistic.R
\name{dist_logistic}
\alias{dist_logistic}
\title{The Logistic distribution}
\usage{
dist_logistic(location, scale)
}
\arguments{
\item{location, scale}{location and scale parameters.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A continuous distribution on the real line. For binary outcomes
the model given by \eqn{P(Y = 1 | X) = F(X \beta)} where
\eqn{F} is the Logistic \code{\link[=cdf]{cdf()}} is called \emph{logistic regression}.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_logistic.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_logistic.html}

In the following, let \eqn{X} be a Logistic random variable with
\code{location} = \eqn{\mu} and \code{scale} = \eqn{s}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: \eqn{\mu}

\strong{Variance}: \eqn{s^2 \pi^2 / 3}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{e^{-\frac{x - \mu}{s}}}{s \left[1 + e^{-\frac{x - \mu}{s}}\right]^2}
  }{
    f(x) = e^(-(x - mu) / s) / (s (1 + e^(-(x - \mu) / s))^2)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = \frac{1}{1 + e^{-\frac{x - \mu}{s}}}
  }{
    F(x) = 1 / (1 + e^(-(x - mu) / s))
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = e^{\mu t} B(1 - st, 1 + st)
  }{
    E(e^(tX)) = e^(mu t) B(1 - st, 1 + st)
  }

for \eqn{-1 < st < 1}, where \eqn{B(a, b)} is the Beta function.
}
\examples{
dist <- dist_logistic(location = c(5,9,9,6,2), scale = c(2,3,4,2,1))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Logistic]{stats::Logistic}
}
