% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{[.CFTime}
\alias{[.CFTime}
\title{Subset a \code{CFTime} instance by position in the time series}
\usage{
\method{[}{CFTime}(x, i = TRUE, ...)
}
\arguments{
\item{x}{A \code{CFTime} instance.}

\item{i}{A vector a positive integer values to indicate which values to
extract from the time series by position. If negative values are passed,
their positive counterparts will be excluded and then the remainder
returned. Positive and negative values may not be mixed.}

\item{...}{Ignored.}
}
\value{
A numeric vector with those values of \code{i} (or the inverse, when
negative) that are valid in \code{x}. If there is at least 1 valid result, then
attribute "CFTime" of the returned value contains an instance of \code{CFTime}
that describes the dimension of filtering the dataset associated with \code{x}
with the result of this function, excluding any \code{NA} values.
}
\description{
Subset a \code{CFTime} instance by position in the time series
}
\references{
https://github.com/R-CF/CFtime/issues/20
}
