# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpdateDownloadProgress(Model):
    """Details about the download progress of update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar download_phase: The download phase. Possible values include:
     'Unknown', 'Initializing', 'Downloading', 'Verifying'
    :vartype download_phase: str or
     ~azure.mgmt.edgegateway.models.DownloadPhase
    :ivar percent_complete: Percentage of completion.
    :vartype percent_complete: int
    :ivar total_bytes_to_download: Total bytes to download.
    :vartype total_bytes_to_download: float
    :ivar total_bytes_downloaded: Total bytes downloaded.
    :vartype total_bytes_downloaded: float
    :ivar number_of_updates_to_download: Number of updates to download.
    :vartype number_of_updates_to_download: int
    :ivar number_of_updates_downloaded: Number of updates downloaded.
    :vartype number_of_updates_downloaded: int
    """

    _validation = {
        'download_phase': {'readonly': True},
        'percent_complete': {'readonly': True},
        'total_bytes_to_download': {'readonly': True},
        'total_bytes_downloaded': {'readonly': True},
        'number_of_updates_to_download': {'readonly': True},
        'number_of_updates_downloaded': {'readonly': True},
    }

    _attribute_map = {
        'download_phase': {'key': 'downloadPhase', 'type': 'str'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'total_bytes_to_download': {'key': 'totalBytesToDownload', 'type': 'float'},
        'total_bytes_downloaded': {'key': 'totalBytesDownloaded', 'type': 'float'},
        'number_of_updates_to_download': {'key': 'numberOfUpdatesToDownload', 'type': 'int'},
        'number_of_updates_downloaded': {'key': 'numberOfUpdatesDownloaded', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpdateDownloadProgress, self).__init__(**kwargs)
        self.download_phase = None
        self.percent_complete = None
        self.total_bytes_to_download = None
        self.total_bytes_downloaded = None
        self.number_of_updates_to_download = None
        self.number_of_updates_downloaded = None
