/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.SiteEdit;
import org.chefproject.core.SitePage;
import org.chefproject.core.SitePageEdit;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.core.ToolRegistration;
import org.chefproject.core.component.RefreshTopDelivery;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.CourierService;
import org.chefproject.service.PortalService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.SiteService;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.StringUtil;

public class SitesAction
extends VelocityPortletPaneledAction {
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute("obsever") == null) {
            String deliveryId = this.clientWindowId(state, portlet.getID());
            String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
            String pattern = SiteService.siteReference("");
            state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String template = null;
        String mode = (String)state.getAttribute("mode");
        if (mode == null) {
            template = this.buildListContext(state, context);
        } else if (mode.equals("new")) {
            template = this.buildNewContext(state, context);
        } else if (mode.equals("edit")) {
            template = this.buildEditContext(state, context);
        } else if (mode.equals("confirm")) {
            template = this.buildConfirmRemoveContext(state, context);
        } else if (mode.equals("saveas")) {
            template = this.buildSaveasContext(state, context);
        } else if (mode.equals("pages")) {
            template = this.buildPagesContext(state, context);
        } else if (mode.equals("newPage")) {
            template = this.buildNewPageContext(state, context);
        } else if (mode.equals("editPage")) {
            template = this.buildEditPageContext(state, context);
        } else if (mode.equals("tools")) {
            template = this.buildToolsContext(state, context);
        } else if (mode.equals("newTool")) {
            template = this.buildNewToolContext(state, context);
        } else if (mode.equals("editTool")) {
            template = this.buildEditToolContext(state, context);
        } else {
            Log.warn("chef", "SitesAction: mode: " + mode);
            template = this.buildListContext(state, context);
        }
        return template;
    }

    private String buildListContext(SessionState state, Context context) {
        context.put("service", SiteService.getInstance());
        List sites = SiteService.getSites();
        Collections.sort(sites);
        context.put("sites", sites);
        boolean menuPopulated = false;
        Menu bar = new Menu();
        if (SiteService.allowAddSite("")) {
            bar.add(new MenuEntry("New Site", "doNew"));
            menuPopulated = true;
        }
        if (menuPopulated) {
            context.put("menu", bar);
        }
        ((EventObservingCourier)state.getAttribute("obsever")).justDelivered();
        return "chef_sites_list";
    }

    private String buildNewContext(SessionState state, Context context) {
        context.put("form-name", "site-form");
        return "chef_sites_edit";
    }

    private String buildEditContext(SessionState state, Context context) {
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        context.put("site", site);
        context.put("form-name", "site-form");
        Menu bar = new Menu();
        if (SiteService.allowRemoveSite(site.getId())) {
            bar.add(new MenuEntry("Remove Site", null, true, 0, "doRemove", "site-form"));
        }
        bar.add(new MenuEntry("Save As", null, true, 0, "doSaveas_request", "site-form"));
        context.put("menu", bar);
        return "chef_sites_edit";
    }

    private String buildConfirmRemoveContext(SessionState state, Context context) {
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        context.put("site", site);
        return "chef_sites_confirm_remove";
    }

    private String buildSaveasContext(SessionState state, Context context) {
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        context.put("site", site);
        return "chef_sites_saveas";
    }

    private String buildPagesContext(SessionState state, Context context) {
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        context.put("site", site);
        List pages = site.getPages();
        context.put("pages", pages);
        Menu bar = new Menu();
        bar.add(new MenuEntry("New Page", "doNew_page"));
        context.put("menu", bar);
        return "chef_sites_pages";
    }

    private String buildNewPageContext(SessionState state, Context context) {
        context.put("form-name", "page-form");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        context.put("site", site);
        context.put("page", page);
        context.put("layouts", this.layoutsList());
        return "chef_sites_edit_page";
    }

    private String buildEditPageContext(SessionState state, Context context) {
        context.put("form-name", "page-form");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        context.put("site", site);
        context.put("page", page);
        Menu bar = new Menu();
        bar.add(new MenuEntry("Remove Page", null, true, 0, "doRemove_page"));
        context.put("menu", bar);
        context.put("layouts", this.layoutsList());
        return "chef_sites_edit_page";
    }

    private String buildToolsContext(SessionState state, Context context) {
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        context.put("site", site);
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        context.put("page", page);
        List tools = page.getTools();
        context.put("tools", tools);
        Menu bar = new Menu();
        bar.add(new MenuEntry("New Tool", "doNew_tool"));
        context.put("menu", bar);
        return "chef_sites_tools";
    }

    private String buildNewToolContext(SessionState state, Context context) {
        context.put("form-name", "tool-form");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        context.put("site", site);
        context.put("page", page);
        context.put("tool", tool);
        List features = ServerConfigurationService.getToolRegistrations();
        Collections.sort(features);
        context.put("features", features);
        return "chef_sites_edit_tool";
    }

    private String buildEditToolContext(SessionState state, Context context) {
        context.put("form-name", "tool-form");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        context.put("site", site);
        context.put("page", page);
        context.put("tool", tool);
        List features = ServerConfigurationService.getToolRegistrations();
        Collections.sort(features);
        context.put("features", features);
        context.put("toolReg", ServerConfigurationService.getToolRegistration(tool.getToolId()));
        Menu bar = new Menu();
        bar.add(new MenuEntry("Remove Tool", null, true, 0, "doRemove_tool"));
        context.put("menu", bar);
        return "chef_sites_edit_tool";
    }

    public void doNew(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"new");
        state.setAttribute("new", (Object)"true");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doEdit(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        try {
            SiteEdit site = SiteService.editSite(id);
            state.setAttribute("site", (Object)site);
            state.setAttribute("mode", (Object)"edit");
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SitesAction.doEdit: site not found: " + id);
            this.addAlert(state, "Site " + id + " not found");
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to edit Site " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (InUseException e) {
            this.addAlert(state, "Someone else is currently editing this Site: " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
    }

    public void doSave(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readSiteForm(data, state)) {
            return;
        }
        this.doSave_edit(data, context);
    }

    public void doSave_edit(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        if (site != null) {
            SiteService.commitEdit(site);
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
        CourierService.deliver(new RefreshTopDelivery(PortalService.getCurrentClientWindowId(null)));
    }

    public void doSaveas_request(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readSiteForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"saveas");
    }

    public void doSaveas(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        try {
            SiteEdit newSite = SiteService.addSite(id, site);
            SiteService.commitEdit(newSite);
        }
        catch (IdUsedException e) {
            this.addAlert(state, "The site id is already in use");
            return;
        }
        catch (IdInvalidException e) {
            this.addAlert(state, "The site id is invalid");
            return;
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to create this Site");
            return;
        }
        SiteService.cancelEdit(site);
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
        CourierService.deliver(new RefreshTopDelivery(PortalService.getCurrentClientWindowId(null)));
    }

    public void doCancel_saveas(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"edit");
    }

    public void doCancel(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        if (site != null) {
            if ("true".equals(state.getAttribute("new"))) {
                try {
                    SiteService.removeSite(site);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "SitesAction.doCancel (new): site id not recognized for remove: " + site.getId());
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have permission to remove Site " + site.getId());
                }
            } else {
                SiteService.cancelEdit(site);
            }
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doRemove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readSiteForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"confirm");
    }

    public void doRemove_confirmed(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        try {
            SiteService.removeSite(site);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "SitesAction.doRemove_confirmed: site id not recognized: " + site.getId());
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to remove Site " + site.getId());
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
        CourierService.deliver(new RefreshTopDelivery(PortalService.getCurrentClientWindowId(null)));
    }

    public void doCancel_remove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readSiteForm(RunData data, SessionState state) {
        String id = StringUtil.trimToNull(data.getParameters().getString("id"));
        String title = StringUtil.trimToNull(data.getParameters().getString("title"));
        String description = StringUtil.trimToNull(data.getParameters().getString("description"));
        boolean joinable = data.getParameters().getBoolean("joinable");
        String joinerRole = StringUtil.trimToNull(data.getParameters().getString("joinerRole"));
        String icon = StringUtil.trimToNull(data.getParameters().getString("icon"));
        String info = StringUtil.trimToNull(data.getParameters().getString("info"));
        String status = StringUtil.trimToNull(data.getParameters().getString("status"));
        String skin = StringUtil.trimToNull(data.getParameters().getString("skin"));
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        if (site == null) {
            try {
                site = SiteService.addSite(id);
                SiteService.commitEdit(site);
                site = SiteService.editSite(id);
                state.setAttribute("site", (Object)site);
            }
            catch (IdUsedException e) {
                this.addAlert(state, "The site id is already in use");
                return false;
            }
            catch (IdInvalidException e) {
                this.addAlert(state, "The site id is invalid");
                return false;
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to edit this Site");
                return false;
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Missing Realm!");
                Log.warn("chef", (Object)((Object)this) + ".readSiteForm: missing the site's realm: @" + id);
                return false;
            }
            catch (InUseException e) {
                this.addAlert(state, "Realm/Site In Use!");
                Log.warn("chef", (Object)((Object)this) + ".readSiteForm: site or realm in use: @" + id);
                return false;
            }
        }
        if (site != null) {
            site.setTitle(title);
            site.setDescription(description);
            site.setJoinable(joinable);
            site.setJoinerRole(joinerRole);
            site.setIconUrl(icon);
            site.setInfoUrl(info);
            site.setSkin(skin);
            try {
                site.setStatus(Integer.parseInt(status));
            }
            catch (Exception e) {
                Log.warn("chef", (Object)((Object)this) + ".readSiteForm(): bad status: " + status);
            }
        }
        return true;
    }

    public void doPages(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readSiteForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"pages");
    }

    public void doNew_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"newPage");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = site.addPage();
        state.setAttribute("page", (Object)page);
        state.setAttribute("newPage", (Object)"true");
    }

    public void doEdit_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"editPage");
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = site.getPageEdit(id);
        state.setAttribute("page", (Object)page);
    }

    public void doEdit_page_up(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = site.getPageEdit(id);
        state.setAttribute("page", (Object)page);
        page.moveUp();
    }

    public void doEdit_page_down(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = site.getPageEdit(id);
        state.setAttribute("page", (Object)page);
        page.moveDown();
    }

    public void doSave_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readPageForm(data, state)) {
            return;
        }
        state.removeAttribute("page");
        this.doSave_edit(data, context);
    }

    public void doDone_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readPageForm(data, state)) {
            return;
        }
        state.removeAttribute("page");
        state.setAttribute("mode", (Object)"pages");
    }

    public void doCancel_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        if ("true".equals(state.getAttribute("newPage"))) {
            site.removePage(page);
        }
        state.removeAttribute("page");
        state.setAttribute("mode", (Object)"pages");
    }

    public void doRemove_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        site.removePage(page);
        state.removeAttribute("page");
        state.setAttribute("mode", (Object)"pages");
    }

    public void doEdit_to_main(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readPageForm(RunData data, SessionState state) {
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        String title = data.getParameters().getString("title");
        page.setTitle(title);
        try {
            int layout = Integer.parseInt(data.getParameters().getString("layout")) - 1;
            page.setLayout(layout);
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".readPageForm(): reading layout: " + e);
        }
        return true;
    }

    public void doTools(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readPageForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"tools");
    }

    public void doNew_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"newTool");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = page.addTool();
        state.setAttribute("tool", (Object)tool);
        state.setAttribute("newTool", (Object)"true");
    }

    public void doEdit_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"editTool");
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = page.getToolEdit(id);
        state.setAttribute("tool", (Object)tool);
    }

    public void doEdit_tool_up(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = page.getToolEdit(id);
        tool.moveUp();
    }

    public void doEdit_tool_down(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = page.getToolEdit(id);
        tool.moveDown();
    }

    public void doSave_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readToolForm(data, state)) {
            return;
        }
        state.removeAttribute("tool");
        this.doSave_edit(data, context);
    }

    public void doDone_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readToolForm(data, state)) {
            return;
        }
        state.removeAttribute("tool");
        state.setAttribute("mode", (Object)"tools");
    }

    public void doDone_feature(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readToolFeatureForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"editTool");
    }

    public void doCancel_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SiteEdit site = (SiteEdit)state.getAttribute("site");
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        if ("true".equals(state.getAttribute("newTool"))) {
            page.removeTool(tool);
        }
        state.removeAttribute("tool");
        state.setAttribute("mode", (Object)"tools");
    }

    public void doRemove_tool(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        SitePageEdit page = (SitePageEdit)state.getAttribute("page");
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        page.removeTool(tool);
        state.removeAttribute("tool");
        state.setAttribute("mode", (Object)"tools");
    }

    public void doEdit_to_page(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"editPage");
    }

    private boolean readToolForm(RunData data, SessionState state) {
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        String title = data.getParameters().getString("title");
        tool.setTitle(title);
        String hints = data.getParameters().getString("layoutHints");
        tool.setLayoutHints(hints);
        String feature = tool.getToolId();
        if (feature != null) {
            ToolRegistration reg = ServerConfigurationService.getToolRegistration(tool.getToolId());
            Iterator iParams = reg.getDefaultConfiguration().getPropertyNames();
            while (iParams.hasNext()) {
                String paramName = (String)iParams.next();
                String formName = "param_" + paramName;
                String value = data.getParameters().getString(formName);
                if (value == null) continue;
                if ((value = StringUtil.trimToNull(value)) != null) {
                    tool.getPropertiesEdit().addProperty(paramName, value);
                    continue;
                }
                tool.getPropertiesEdit().removeProperty(paramName);
            }
        } else {
            this.addAlert(state, "Please select a feature for this tool.");
            return false;
        }
        return true;
    }

    private boolean readToolFeatureForm(RunData data, SessionState state) {
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        String feature = data.getParameters().getString("feature");
        ToolRegistration reg = ServerConfigurationService.getToolRegistration(feature);
        if (!feature.equals(tool.getToolId())) {
            tool.setToolId(feature);
            tool.setTitle(reg.getTitle());
            tool.getPropertiesEdit().clear();
            tool.getPropertiesEdit().addAll(reg.getDefaultConfiguration());
        }
        return true;
    }

    private void cleanState(SessionState state) {
        state.removeAttribute("site");
        state.removeAttribute("page");
        state.removeAttribute("tool");
        state.removeAttribute("new");
        state.removeAttribute("newPage");
        state.removeAttribute("newTool");
    }

    private List layoutsList() {
        Vector<String> rv = new Vector<String>();
        int i = 0;
        while (i < SitePage.LAYOUT_NAMES.length) {
            rv.add(SitePage.LAYOUT_NAMES[i]);
            ++i;
        }
        return rv;
    }
}

