/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("expectedMaxSize is negative: ").append(n).toString());
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2;
        int n3 = 3 * n / 2;
        if (n3 > 0x20000000 || n3 < 0) {
            n2 = 0x20000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private void init(int n) {
        this.threshold = n * 2 / 3;
        this.table = new Object[2 * n];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n) {
        int n2 = System.identityHashCode(object);
        return (n2 << 1) - (n2 << 8) & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 2 < n2 ? n + 2 : 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return (V)objectArray[n2 + 1];
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        Object object3;
        while ((object3 = objectArray[n2]) != object2) {
            if (object3 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i = 1; i < objectArray.length; i += 2) {
            if (objectArray[i] != object) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        Object object4;
        while ((object4 = objectArray[n2]) != object3) {
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        return objectArray[n2 + 1] == object2;
    }

    @Override
    public V put(K k, V v) {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while ((object = objectArray[n2]) != null) {
            if (object == object2) {
                Object object3 = objectArray[n2 + 1];
                objectArray[n2 + 1] = v;
                return (V)object3;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        ++this.modCount;
        objectArray[n2] = object2;
        objectArray[n2 + 1] = v;
        if (++this.size >= this.threshold) {
            this.resize(n);
        }
        return null;
    }

    private void resize(int n) {
        int n2 = n * 2;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        if (n3 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n3 >= n2) {
            return;
        }
        Object[] objectArray2 = new Object[n2];
        this.threshold = n2 / 3;
        for (int i = 0; i < n3; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = objectArray[i + 1];
            objectArray[i] = null;
            objectArray[i + 1] = null;
            int n4 = IdentityHashMap.hash(object, n2);
            while (objectArray2[n4] != null) {
                n4 = IdentityHashMap.nextKeyIndex(n4, n2);
            }
            objectArray2[n4] = object;
            objectArray2[n4 + 1] = object2;
        }
        this.table = objectArray2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put((K)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n2]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n2 + 1];
                objectArray[n2 + 1] = null;
                objectArray[n2] = null;
                this.closeDeletion(n2);
                return (V)object4;
            }
            if (object3 == null) {
                return null;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object3, n);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n2]) == object3) {
                if (objectArray[n2 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
                this.closeDeletion(n2);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        Object object;
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.nextKeyIndex(n, n2);
        while ((object = objectArray[n3]) != null) {
            int n4 = IdentityHashMap.hash(object, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                objectArray[n] = object;
                objectArray[n + 1] = objectArray[n3 + 1];
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                n = n3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i = 0; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                if (object2 == null || this.containsMapping(object2, objectArray[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[i + 1]);
        }
        return n;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet(this, null);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values(this, null);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet(this, null);
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(objectArray[i + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.init(this.capacity(n * 4 / 3));
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void putForCreate(K k, V v) throws IOException {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k);
        Object[] objectArray = this.table;
        int n = objectArray.length;
        int n2 = IdentityHashMap.hash(object2, n);
        while ((object = objectArray[n2]) != null) {
            if (object == object2) {
                throw new StreamCorruptedException();
            }
            n2 = IdentityHashMap.nextKeyIndex(n2, n);
        }
        objectArray[n2] = object2;
        objectArray[n2 + 1] = v;
    }

    static /* synthetic */ int access$000(IdentityHashMap identityHashMap) {
        return identityHashMap.size;
    }

    static /* synthetic */ Object[] access$100(IdentityHashMap identityHashMap) {
        return identityHashMap.table;
    }

    static /* synthetic */ int access$200(IdentityHashMap identityHashMap) {
        return identityHashMap.modCount;
    }

    static /* synthetic */ int access$204(IdentityHashMap identityHashMap) {
        return ++identityHashMap.modCount;
    }

    static /* synthetic */ int access$010(IdentityHashMap identityHashMap) {
        return identityHashMap.size--;
    }

    static /* synthetic */ int access$300(int n, int n2) {
        return IdentityHashMap.nextKeyIndex(n, n2);
    }

    static /* synthetic */ int access$400(Object object, int n) {
        return IdentityHashMap.hash(object, n);
    }

    static /* synthetic */ Object access$600(Object object) {
        return IdentityHashMap.unmaskNull(object);
    }

    static /* synthetic */ boolean access$1300(IdentityHashMap identityHashMap, Object object, Object object2) {
        return identityHashMap.containsMapping(object, object2);
    }

    static /* synthetic */ boolean access$1400(IdentityHashMap identityHashMap, Object object, Object object2) {
        return identityHashMap.removeMapping(object, object2);
    }

    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>> {
        private java.util.IdentityHashMap$EntryIterator.Entry lastReturnedEntry;

        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastReturnedEntry = new Entry(this.nextIndex());
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            this.lastReturnedIndex = null == this.lastReturnedEntry ? -1 : this.lastReturnedEntry.index;
            super.remove();
            this.lastReturnedEntry.index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;

            private Entry(int index) {
                this.index = index;
            }

            public K getKey() {
                this.checkIndexForEntryUse();
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]);
            }

            public V getValue() {
                this.checkIndexForEntryUse();
                return EntryIterator.this.traversalTable[this.index + 1];
            }

            public V setValue(V value) {
                this.checkIndexForEntryUse();
                Object oldValue = EntryIterator.this.traversalTable[this.index + 1];
                EntryIterator.this.traversalTable[this.index + 1] = value;
                if (EntryIterator.this.traversalTable != IdentityHashMap.this.table) {
                    IdentityHashMap.this.put(EntryIterator.this.traversalTable[this.index], value);
                }
                return oldValue;
            }

            @Override
            public boolean equals(Object o) {
                Map.Entry e;
                if (this.index < 0) {
                    return super.equals(o);
                }
                return o instanceof Map.Entry && (e = (Map.Entry)o).getKey() == IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) && e.getValue() == EntryIterator.this.traversalTable[this.index + 1];
            }

            @Override
            public int hashCode() {
                if (EntryIterator.this.lastReturnedIndex < 0) {
                    return super.hashCode();
                }
                return System.identityHashCode(IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index])) ^ System.identityHashCode(EntryIterator.this.traversalTable[this.index + 1]);
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) + "=" + EntryIterator.this.traversalTable[this.index + 1];
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw new IllegalStateException("Entry was removed");
                }
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && IdentityHashMap.this.containsMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry;
            return o instanceof Map.Entry && IdentityHashMap.this.removeMapping((entry = (Map.Entry)o).getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                Object key = tab[si];
                if (key == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = new AbstractMap.SimpleEntry<Object, Object>(IdentityHashMap.unmaskNull(key), tab[si + 1]);
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private abstract class IdentityHashMapIterator<T>
    implements Iterator<T> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            for (int i = this.index; i < tab.length; i += 2) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(key);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            --IdentityHashMap.this.size;
            int i = IdentityHashMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = IdentityHashMap.hash(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == IdentityHashMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = IdentityHashMap.nextKeyIndex(i, len);
            }
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        private KeyIterator(IdentityHashMap identityHashMap) {
        }

        @Override
        public K next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(IdentityHashMap.this);
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IdentityHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(o);
            return IdentityHashMap.this.size != oldSize;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (Object key : this) {
                result += System.identityHashCode(key);
            }
            return result;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                Object key = tab[si];
                if (key == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = IdentityHashMap.unmaskNull(key);
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        private ValueIterator(IdentityHashMap identityHashMap) {
        }

        @Override
        public V next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(IdentityHashMap.this);
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IdentityHashMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (i.next() != o) continue;
                i.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                if (tab[si] == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = tab[si + 1];
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }
}

