#### Note: this error code is no longer emitted by the compiler.

An explicit generic argument was provided when calling a function that
uses `impl Trait` in argument position.

Erroneous code example:

```ignore (no longer an error)
fn foo<T: Copy>(a: T, b: impl Clone) {}

foo::<i32>(0i32, "abc".to_string());
```

Either all generic arguments should be inferred at the call site, or
the function definition should use an explicit generic type parameter
instead of `impl Trait`. Example:

```
fn foo<T: Copy>(a: T, b: impl Clone) {}
fn bar<T: Copy, U: Clone>(a: T, b: U) {}

foo(0i32, "abc".to_string());

bar::<i32, String>(0i32, "abc".to_string());
bar::<_, _>(0i32, "abc".to_string());
bar(0i32, "abc".to_string());
```
