/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GAME_H_
#define _GAME_H_

#include <gtk/gtk.h>

#include "ball.h"
#include "highscore.h"
#include "pocket.h"
#include "tube_pair.h"

class Game {
   typedef enum {UserDefined, Beginner, Intermediate, Expert} Mode;

   static gboolean DeleteEvent(GtkWidget* widget, GdkEvent* event, 
			       gpointer data);
   static void GoCB(GtkWidget *widget, gpointer data);
   static gchar* MenuTranslate(const gchar *path, gpointer data);
   static gint Timeout(gpointer data);
   void MoveBalls();
   void DisplayMoves();
   void DisplayTime();
   void StopTime();
   bool IsNewHighScore();
   void Go();
   TubePair* Construct(int m, int n, int row, int column);
   void ConnectBottom(TubePair* p1, TubePair* p2);
   void ConnectRight(TubePair* p1, TubePair* p2);
public:
   Game(int argc, char** argv);
   void Build();
   void Shuffle();
   void NewGame(int rows, int columns);
   void NewBeginnerGame() {
      NewGame(2, 2);}
   void NewIntermediateGame() {
      NewGame(5, 5);}
   void NewExpertGame() {
      NewGame(9, 9);}
   void Start();
   bool IsSolved();
   void AddHighScore(const char* name);
   void ShowHighScore();
   void EnableTooltips(bool enable);
protected:
   static void OnNew(GtkWidget *widget, gpointer data);
   static void OnShowHighscore(GtkWidget *widget, gpointer data);
   static void OnOptions(GtkWidget *widget, gpointer data);
   static void OnQuit(GtkWidget *widget, gpointer data);
   static void OnAbout(GtkWidget *widget, gpointer data);

   void SetTooltip(GtkWidget* widget, const char* text);
private:
   Game::Mode		_mode;
   int			_rows;
   int			_columns;
   int			_nr_of_moves;
   int			_seconds;
   static Game*		_instance;
   static GtkItemFactoryEntry _menu_items[];
   GtkWidget*		_toolbar;
   GtkWidget* 		_frame;
   GtkWidget*		_table;
   GtkWidget* 		_moves;
   GtkWidget*		_time;
   GtkWidget*		_go;
   GtkTooltips*		_tooltips;
   gint			_timeout;

   SetOffBalls		_balls;
   SetOffPockets 	_pockets;
   SetOffTubePairs	_tube_pairs;

   HighScore		_high_score;
};

#endif // _GAME_H_
