/*
  Copyright (c) 2011-2012 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2011-2012 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
  THIS FILE IS GENERATED by
  scripts/gen-esa-bottomup.rb
  --key maxpairs
  --reader
  --absolute
  --sa_reader_sain
  --fatherwithlb
  --no_process_lcpinterval.
  DO NOT EDIT.
*/

#include <limits.h>
#include "core/ma.h"
#include "esa-seqread.h"
/* no include for seqnumrelpos.h */

static void initBUinfo_maxpairs(GtBUinfo_maxpairs *,
                              GtBUstate_maxpairs *);

static void freeBUinfo_maxpairs(GtBUinfo_maxpairs *,
                              GtBUstate_maxpairs *);

static int processleafedge_maxpairs(bool,
    GtUword,
    GtBUinfo_maxpairs *,
    GtUword, /* position */
    GtBUstate_maxpairs *,
    GtError *err);

static int processbranchingedge_maxpairs(bool firstsucc,GtUword,GtUword,
GtBUinfo_maxpairs *,
    GtUword,
    GtUword,
    GtBUinfo_maxpairs *,
    GtBUstate_maxpairs *,
    GtError *);

/* no declaration of processlcpinterval_maxpairs */

#define TOP_ESA_BOTTOMUP_maxpairs\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo-1]

#define POP_ESA_BOTTOMUP_maxpairs\
        (stack->spaceGtBUItvinfo + (--stack->nextfreeGtBUItvinfo))

#define PUSH_ESA_BOTTOMUP_maxpairs(LCP,LB)\
        if (stack->nextfreeGtBUItvinfo >= stack->allocatedGtBUItvinfo)\
        {\
          gt_assert(stack->nextfreeGtBUItvinfo ==\
                    stack->allocatedGtBUItvinfo);\
          stack->spaceGtBUItvinfo\
            = allocateBUstack_maxpairs(stack->spaceGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo+incrementstacksize,\
                              bustate);\
          stack->allocatedGtBUItvinfo += incrementstacksize;\
        }\
        gt_assert(stack->spaceGtBUItvinfo != NULL);\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lcp = LCP;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lb = LB;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo++].rb = ULONG_MAX

typedef struct
{
  GtUword lcp, lb, rb;
  GtBUinfo_maxpairs info;
} GtBUItvinfo_maxpairs;

typedef struct
{
  GtBUItvinfo_maxpairs *spaceGtBUItvinfo;
  GtUword allocatedGtBUItvinfo,
                nextfreeGtBUItvinfo;
} GtArrayGtBUItvinfo_maxpairs;

GtArrayGtBUItvinfo_maxpairs *gt_GtArrayGtBUItvinfo_new_maxpairs(void)
{
  GtArrayGtBUItvinfo_maxpairs *stack = gt_malloc(sizeof (*stack));

  stack->spaceGtBUItvinfo = NULL;
  stack->allocatedGtBUItvinfo = stack->nextfreeGtBUItvinfo = 0;
  return stack;
}

void gt_GtArrayGtBUItvinfo_delete_maxpairs(
                           GtArrayGtBUItvinfo_maxpairs *stack,
                           GtBUstate_maxpairs *state)
{
  GtUword idx;

  for (idx=0; idx<stack->allocatedGtBUItvinfo; idx++)
  {
    freeBUinfo_maxpairs(&stack->spaceGtBUItvinfo[idx].info,state);
  }
  gt_free(stack->spaceGtBUItvinfo);
  gt_free(stack);
}

static GtBUItvinfo_maxpairs *allocateBUstack_maxpairs(
                                   GtBUItvinfo_maxpairs *ptr,
                                   GtUword currentallocated,
                                   GtUword allocated,
                                   GtBUstate_maxpairs *state)
{
  GtUword idx;
  GtBUItvinfo_maxpairs *itvinfo;

  itvinfo = gt_realloc(ptr,sizeof (*itvinfo) * allocated);
  gt_assert(allocated > currentallocated);
  for (idx=currentallocated; idx<allocated; idx++)
  {
    initBUinfo_maxpairs(&itvinfo[idx].info,state);
  }
  gt_assert(itvinfo != NULL);
  return itvinfo;
}

static int gt_esa_bottomup_maxpairs(Sequentialsuffixarrayreader *ssar,
GtSainSufLcpIterator *ssli,
                    GtBUstate_maxpairs *bustate,
                    /* no parameter snrp */
                    GtError *err)
{
  const GtUword incrementstacksize = 32UL;
  GtUword lcpvalue,
                previoussuffix = 0,
                idx,
                numberofsuffixes,
                lastsuftabvalue = 0;
  GtBUItvinfo_maxpairs *lastinterval = NULL;
  bool haserr = false, firstedge, firstedgefromroot = true;
  GtArrayGtBUItvinfo_maxpairs *stack;

  stack = gt_GtArrayGtBUItvinfo_new_maxpairs();
  PUSH_ESA_BOTTOMUP_maxpairs(0,0);
  numberofsuffixes = gt_ssar_ssli_nonspecials(ssar,ssli);
  for (idx = 0; !haserr && idx < numberofsuffixes; idx++)
  {
    SSAR_SSLI_NEXT_SUF_LCP(ssar,ssli,previoussuffix,lcpvalue,lastsuftabvalue);
    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_maxpairs.lcp)
    {
      if (TOP_ESA_BOTTOMUP_maxpairs.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_maxpairs(firstedge,
                          TOP_ESA_BOTTOMUP_maxpairs.lcp,
                          &TOP_ESA_BOTTOMUP_maxpairs.info,
                          previoussuffix,
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_maxpairs.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_maxpairs;
      lastinterval->rb = idx;
      /* no call to processlcpinterval_maxpairs */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_maxpairs.lcp)
      {
        if (TOP_ESA_BOTTOMUP_maxpairs.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_maxpairs(firstedge,
               TOP_ESA_BOTTOMUP_maxpairs.lcp,
            TOP_ESA_BOTTOMUP_maxpairs.lb,
               &TOP_ESA_BOTTOMUP_maxpairs.info,
               lastinterval->lcp,
               lastinterval->rb - lastinterval->lb + 1,
               &lastinterval->info,
               bustate,
               err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_maxpairs.lcp)
    {
      if (lastinterval != NULL)
      {
        GtUword lastintervallb = lastinterval->lb;
        GtUword lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_maxpairs(lcpvalue,lastintervallb);
        if (processbranchingedge_maxpairs(true,
                       TOP_ESA_BOTTOMUP_maxpairs.lcp,
            TOP_ESA_BOTTOMUP_maxpairs.lb,
                       &TOP_ESA_BOTTOMUP_maxpairs.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_maxpairs(lcpvalue,idx);
        if (processleafedge_maxpairs(true,
                            TOP_ESA_BOTTOMUP_maxpairs.lcp,
                            &TOP_ESA_BOTTOMUP_maxpairs.info,
                            previoussuffix,
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  }
  gt_assert(stack->nextfreeGtBUItvinfo > 0);
  if (!haserr && TOP_ESA_BOTTOMUP_maxpairs.lcp > 0)
  {
    /* no assignment to lastsuftabvalue */
    if (processleafedge_maxpairs(false,
                        TOP_ESA_BOTTOMUP_maxpairs.lcp,
                        &TOP_ESA_BOTTOMUP_maxpairs.info,
                        lastsuftabvalue,
                        bustate,
                        err) != 0)
    {
      haserr = true;
    } else
    {
      TOP_ESA_BOTTOMUP_maxpairs.rb = idx;
      /* no call to processlcpinterval_maxpairs */
    }
  }
  gt_GtArrayGtBUItvinfo_delete_maxpairs(stack,bustate);
  return haserr ? -1 : 0;
}
