&QS
  METHOD GPW
  EPS_DEFAULT 1.0E-12
  EXTRAPOLATION ASPC
  EXTRAPOLATION_ORDER 3
  &CDFT
    TYPE_OF_CONSTRAINT HIRSHFELD
    STRENGTH        ${HIRSHFELD_STR}
    TARGET          ${HIRSHFELD_TARGET}

      &ATOM_GROUP
        ATOMS           1 2
        COEFF           1 -1
      &END ATOM_GROUP

  &OUTER_SCF ON
        TYPE CDFT_CONSTRAINT
        MAX_SCF 50

        EPS_SCF 1.0E-3
        OPTIMIZER NEWTON_LS

        &CDFT_OPT ON
          CONTINUE_LS TRUE
        &END CDFT_OPT
      &END

          &HIRSHFELD_CONSTRAINT
        SHAPE_FUNCTION DENSITY
     &END HIRSHFELD_CONSTRAINT

    &PROGRAM_RUN_INFO ON
      ! Print weight function to cube file
      @IF ( ${PRINT_WEIGHT_FUNCTION} == TRUE )
        &WEIGHT_FUNCTION
        &END WEIGHT_FUNCTION
      @ENDIF
      &EACH
        QS_SCF 1
      &END EACH
      COMMON_ITERATION_LEVELS 2
      ADD_LAST NUMERIC
      FILENAME ./${PROJECT_NAME}
    &END PROGRAM_RUN_INFO
  &END CDFT
&END QS
