/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "DialogBook.h"
//#define _DEBUG_


DialogBook::DialogBook(Book* pbook)
: book(pbook),
  table(7, 2),
  label_author(_("Author:"), 0, 0.5),
  label_author_str("", 0, 0.5),
  label_title(_("Title:"), 0, 0.5),
  label_title_str("", 0, 0.5),
  label_isbn(_("ISBN:"), 0, 0.5),
  label_isbn_str("", 0, 0.5),
  label_category(_("Category:"), 0, 0.5),
  label_category_str("", 0, 0.5),
  label_rating(_("Rating:"), 0, 0.5),
  label_readdate(_("Read:"), 0, 0.5),
  label_readdate_str("", 0, 0.5),
  label_summary(_("Summary:"), 0, 0.5),
  label_summary_str("", 0, 0),
  label_review(_("Review:"), 0, 0.5),
  label_review_str("", 0, 0),
  label_button_edit(_("Edit Book")),
  image_button_edit(Gtk::Stock::JUSTIFY_LEFT,
                    Gtk::IconSize(Gtk::ICON_SIZE_SMALL_TOOLBAR)),
  button_close(Gtk::Stock::CLOSE)
{
  set_size_request(450, -1);
  table.set_row_spacings(3);
  table.set_col_spacings(12);
  table.set_border_width(12);
  add(table);
  
  string title = book->get_title();
  set_title(title != "" ? title : _("Unnamed Book"));
  
  // Author.
  table.attach(label_author,     0, 1, 0, 1, Gtk::FILL, Gtk::FILL);
  table.attach(label_author_str, 1, 2, 0, 1, Gtk::EXPAND|Gtk::FILL, Gtk::FILL);
  label_author_str.set_text(book->get_author());
  label_author_str.set_selectable(TRUE);
  
  // Title.
  table.attach(label_title,     0, 1, 1, 2, Gtk::FILL, Gtk::FILL);
  table.attach(label_title_str, 1, 2, 1, 2, Gtk::EXPAND|Gtk::FILL, Gtk::FILL);
  label_title_str.set_text(book->get_title());
  label_title_str.set_selectable(TRUE);
  
  // ISBN-Number.
  table.attach(label_isbn,     0, 1, 2, 3, Gtk::FILL, Gtk::FILL);
  table.attach(label_isbn_str, 1, 2, 2, 3, Gtk::EXPAND|Gtk::FILL, Gtk::FILL);
  label_isbn_str.set_text(book->get_isbn());
  label_isbn_str.set_selectable(TRUE);
  
  // Category.
  table.attach(label_category,     0, 1, 3, 4, Gtk::FILL, Gtk::FILL);
  table.attach(label_category_str, 1, 2, 3, 4, Gtk::EXPAND|Gtk::FILL,
                                               Gtk::FILL);
  label_category_str.set_text(book->get_category());
  label_category_str.set_selectable(TRUE);
  
  // Rating.
  char imgfile[2000];
  snprintf(imgfile, 2000, PACKAGE_PIXMAPS_DIR "/stars%i.png",
                                              book->get_rating() + 1);
  image_rating.set(imgfile);
  image_rating.set_alignment(0, 0.5);
  table.attach(label_rating, 0, 1, 4, 5, Gtk::FILL, Gtk::FILL);
  table.attach(image_rating, 1, 2, 4, 5, Gtk::EXPAND|Gtk::FILL, Gtk::FILL);
  
  // Read date selector.
  table.attach(label_readdate,     0, 1, 5, 6, Gtk::FILL, Gtk::FILL);
  table.attach(label_readdate_str, 1, 2, 5, 6, Gtk::EXPAND|Gtk::FILL,
                                               Gtk::FILL);
  label_readdate_str.set_text(book->get_readdate_string());
  label_readdate_str.set_selectable(TRUE);
  table.set_row_spacing(5, 12);
  
  // Summary
  table.attach(label_summary, 0, 2, 6, 7, Gtk::FILL, Gtk::FILL);
  scroll_summary.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  scroll_summary.set_shadow_type(Gtk::SHADOW_NONE);
  label_summary_str.set_line_wrap();
  label_summary_str.set_selectable(TRUE);
  scroll_summary.add(label_summary_str);
  table.attach(scroll_summary, 0, 2, 7, 8);
  table.set_row_spacing(7, 12);
  label_summary_str.set_text(book->get_summary());
  
  // Review
  table.attach(label_review, 0, 2, 8, 9, Gtk::FILL, Gtk::FILL);
  scroll_review.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  scroll_review.set_shadow_type(Gtk::SHADOW_NONE);
  label_review_str.set_line_wrap();
  label_review_str.set_selectable(TRUE);
  scroll_review.add(label_review_str);
  table.attach(scroll_review, 0, 2, 9, 10);
  table.set_row_spacing(9, 12);
  label_review_str.set_text(book->get_review());
  
  // Buttons
  {
    buttonbox.set_spacing(12);
    table.attach(buttonbox, 0, 2, 10, 11, Gtk::FILL, Gtk::FILL);
    
    // Add some distance.
    buttonbox.pack_start(fixed, TRUE, TRUE);
    
    // "Edit".
    hbox_button_edit.set_spacing(3);
    hbox_button_edit.pack_start(image_button_edit);
    hbox_button_edit.pack_start(label_button_edit);
    button_edit.add(hbox_button_edit);
    button_edit.set_size_request(-1, 35);
    buttonbox.pack_start(button_edit, FALSE, TRUE);
    button_edit.signal_clicked().connect(
      sigc::mem_fun(*this, &DialogBook::on_button_edit_clicked));
    
    // "Close".
    button_close.set_size_request(-1, 35);
    buttonbox.pack_start(button_close, FALSE, TRUE);
    button_close.signal_clicked().connect(
      sigc::mem_fun(*this, &DialogBook::on_button_close_clicked));
  }
  
  signal_delete_event().connect(
      sigc::mem_fun(*this, &DialogBook::on_window_delete_event));
  
  show_all();
}


DialogBook::~DialogBook()
{
}


Book* DialogBook::get_book(void)
{
  return book;
}


void DialogBook::on_button_edit_clicked(void)
{
#ifdef _DEBUG_
  printf("DialogBook::on_button_cancel_clicked(): Called.\n");
#endif
  signal_button_edit_clicked.emit(this, book);
}


void DialogBook::on_button_close_clicked(void)
{
#ifdef _DEBUG_
  printf("DialogBook::on_button_save_clicked(): Called.\n");
#endif
  signal_button_close_clicked.emit(this, book);
}


bool DialogBook::on_window_delete_event(GdkEventAny* trash)
{
  on_button_close_clicked();
  return FALSE;
}
