/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:09:59 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileFilter;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate;
import org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.FileNode;
import uk.ac.sanger.artemis.io.UI;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FileNode_ESTest extends FileNode_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      String string0 = fileNode0.toString();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      File file0 = MockFile.createTempFile("uk.ac.sanger.artemis.components.filetree.FileNode", "\"}I3<A}?+oTFh)");
      FileNode fileNode0 = new FileNode(file0);
      boolean boolean0 = fileNode0.isLeaf();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MockFile mockFile0 = new MockFile("uq e2>y`tfp_n");
      MockFile.createTempFile("L?0XvU", "", (File) mockFile0);
      FileNode fileNode0 = new FileNode(mockFile0);
      boolean boolean0 = fileNode0.isDirectory();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MockFile mockFile0 = new MockFile("3c$jIl#*Y59$L=XzjoZ");
      FileNode fileNode0 = new FileNode(mockFile0);
      MockFileOutputStream mockFileOutputStream0 = new MockFileOutputStream(mockFile0);
      ObjectOutputStream objectOutputStream0 = new ObjectOutputStream(mockFileOutputStream0);
      File file0 = fileNode0.getFile();
      assertTrue(file0.isFile());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      System.setCurrentTimeMillis((-940L));
      File file0 = MockFile.createTempFile("uCYcTT]$S", "BND", (File) null);
      FileNode fileNode0 = new FileNode(file0);
      File file1 = fileNode0.getFile();
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file1.getParent());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".mw\u0005{lGRiY\"fs#7E");
      FileNode fileNode0 = new FileNode(mockFile0);
      File file0 = fileNode0.getFile();
      assertNull(file0.getParent());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      File file0 = fileNode0.getFile();
      assertNull(file0.getParent());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      TrueFileFilter trueFileFilter0 = (TrueFileFilter)TrueFileFilter.INSTANCE;
      Object[] objectArray0 = fileNode0.getChildren(trueFileFilter0);
      assertNotNull(objectArray0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      File file0 = MockFile.createTempFile("uk.ac.sanger.artemis.components.filetree.FileNode", "\"}I3<A}?+oTFh)");
      FileNode fileNode0 = new FileNode(file0);
      boolean boolean0 = fileNode0.getAllowsChildren();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      File file0 = MockFile.createTempFile("?am", "uk.ac.sanger.artemis.components.filetree.FileNode");
      FileNode fileNode0 = new FileNode(file0);
      // Undeclared exception!
      try { 
        fileNode0.isDataFlavorSupported((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      // Undeclared exception!
      try { 
        fileNode0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MockFile mockFile0 = new MockFile("org.apache.commons.io.filefilter.NameFileFilter", "");
      FileNode fileNode0 = new FileNode(mockFile0);
      MockMinguoDate mockMinguoDate0 = new MockMinguoDate();
      fileNode0.setUserObject(mockMinguoDate0);
      // Undeclared exception!
      try { 
        fileNode0.getFile();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFile mockFile0 = new MockFile("zLg @0~\"v+Yj!47Ql", "zLg @0~\"v+Yj!47Ql");
      MockFile.createTempFile("zLg @0~\"v+Yj!47Ql", "", (File) mockFile0);
      FileNode fileNode0 = new FileNode(mockFile0);
      MockJapaneseDate mockJapaneseDate0 = new MockJapaneseDate();
      fileNode0.setUserObject(mockJapaneseDate0);
      // Undeclared exception!
      try { 
        fileNode0.getChildren((FileFilter) null);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FileNode fileNode0 = null;
      try {
        fileNode0 = new FileNode((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      File file0 = MockFile.createTempFile("uk.ac.sanger.artemis.components.filetree.FileNode", "\"}I3<A}?+oTFh)");
      FileNode fileNode0 = new FileNode(file0);
      boolean boolean0 = fileNode0.isDirectory();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MockFile mockFile0 = new MockFile("3c$jIl#*Y59$L=XzjoZ");
      FileNode fileNode0 = new FileNode(mockFile0);
      Class<Integer> class0 = Integer.class;
      DataFlavor dataFlavor0 = new DataFlavor(class0, (String) null);
      try { 
        fileNode0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // application/x-java-serialized-object
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile("O8xe+");
      FileNode fileNode0 = new FileNode(mockFile0);
      FileNode fileNode1 = (FileNode)fileNode0.getTransferData(fileNode0.FILENODE);
      assertFalse(fileNode1.isDirectory());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MockFile mockFile0 = new MockFile("3c$jIl#*Y59$L=XzjoZ");
      FileNode fileNode0 = new FileNode(mockFile0);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      Object object0 = fileNode0.getTransferData(dataFlavor0);
      assertEquals(java.lang.System.getProperty("user.dir") + "/3c$jIl#*Y59$L=XzjoZ", object0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      MockFile mockFile0 = new MockFile("lr");
      FileNode fileNode0 = new FileNode(mockFile0);
      Class<UI.UIMode> class0 = UI.UIMode.class;
      DataFlavor dataFlavor0 = new DataFlavor(class0, "I_qCMfX#");
      boolean boolean0 = fileNode0.isDataFlavorSupported(dataFlavor0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Local file");
      FileNode fileNode0 = new FileNode(mockFile0);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      boolean boolean0 = fileNode0.isDataFlavorSupported(dataFlavor0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      boolean boolean0 = fileNode0.isDataFlavorSupported(fileNode0.FILENODE);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      MockFile mockFile0 = new MockFile("O8xe+");
      FileNode fileNode0 = new FileNode(mockFile0);
      fileNode0.setDirectory(true);
      FileFileFilter fileFileFilter0 = (FileFileFilter)FileFileFilter.FILE;
      fileNode0.getChildren(fileFileFilter0);
      assertTrue(fileNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      MockFile mockFile0 = new MockFile("zLg @0~\"v+Yj!47Ql", "zLg @0~\"v+Yj!47Ql");
      MockFile.createTempFile("zLg @0~\"v+Yj!47Ql", ")(+ B mCQ3%Y", (File) mockFile0);
      FileNode fileNode0 = new FileNode(mockFile0);
      Object[] objectArray0 = fileNode0.getChildren((FileFilter) null);
      Object[] objectArray1 = fileNode0.getChildren((FileFilter) null);
      assertSame(objectArray1, objectArray0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      File file0 = MockFile.createTempFile("uk.ac.sanger.artemis.components.filetree.FileNode", "\"}I3<A}?+oTFh)");
      FileNode fileNode0 = new FileNode(file0);
      String string0 = fileNode0.toString();
      assertEquals("uk.ac.sanger.artemis.components.filetree.FileNode0\"}I3<A}?+oTFh)", string0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      FileNode fileNode0 = new FileNode(mockFile0);
      String string0 = fileNode0.toString();
      assertEquals("/", string0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      MockFile mockFile0 = new MockFile("uq e2>y`tfp_n");
      MockFile.createTempFile("L?0XvU", "", (File) mockFile0);
      URI uRI0 = mockFile0.toURI();
      MockFile mockFile1 = new MockFile(uRI0);
      FileNode fileNode0 = new FileNode(mockFile1);
      boolean boolean0 = fileNode0.isLeaf();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      MockFile mockFile0 = new MockFile("org.apache.commons.io.filefilter.NameFileFilter", "");
      FileNode fileNode0 = new FileNode(mockFile0);
      DataFlavor[] dataFlavorArray0 = fileNode0.getTransferDataFlavors();
      assertNotNull(dataFlavorArray0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileNode fileNode0 = new FileNode(mockFile0);
      boolean boolean0 = fileNode0.getAllowsChildren();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      MockFile mockFile0 = new MockFile("n");
      FileNode fileNode0 = new FileNode(mockFile0);
      fileNode0.reset();
      assertFalse(fileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      MockFile mockFile0 = new MockFile("zLg @0~\"v+Yj!47Ql", "zLg @0~\"v+Yj!47Ql");
      FileNode fileNode0 = new FileNode(mockFile0);
      Object[] objectArray0 = fileNode0.getChildren((FileFilter) null);
      assertNull(objectArray0);
  }
}
